/* <nagf01.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f01 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2149 (Feb 1998).
 * Mark 6 revised. IER-3032 (July 2000).
 */
#ifndef NAGF01
#define NAGF01

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern void f01aac(double a[], Integer tda, Integer n, double x[], Integer tdx,
                     NagError *fail);
  extern void f01acc(Integer n, double a[], Integer tda, double b[], Integer tdb,
                     double z[], Integer *ell, NagError *fail);
  extern void f01acz_f(Integer n, double eps, double a[], Integer ia,
                       double b[], Integer ib, double z[], Integer *l,
                       Integer *ifail);
  extern void f01acz(Integer n, double eps, double a[], Integer tda, double b[],
                     Integer tdb, double z[], Integer *l, Integer *ifail);
  extern void f01adc(Integer n, double a[], Integer tda, NagError *fail);
  extern void f01adf_f(Integer n, double a[], Integer ia, Integer *ifail);
  extern void f01aec(Integer n, double a[], Integer tda, double b[],
                     Integer tdb, double dl[], NagError *fail);
  extern void f01afc(Integer n, Integer im1, Integer im2, double b[], Integer tdb,
                     double dl[], double z[], Integer tdz);
  extern void f01agc(Integer n, double a[], Integer tda, double d[], double e[],
                     double e2[]);
  extern void f01ajc(Integer n, double a[], Integer tda, double d[], 
                     double e[], double z[], Integer tdz);
  extern void f01akc(Integer n, Integer k, Integer l,  double a[],  Integer tda,
                     Integer intger[]);
  extern void f01akz_f(Integer n, Integer k, Integer l, double a[],
                       Integer ia, Integer intger[]);
  extern void f01apc(Integer n, Integer low, Integer iupp, Integer intger[],
                     double h[],  Integer tdh,  double v[],  Integer tdv);
  extern void f01atc(Integer n, Integer ib, double a[], Integer tda, Integer *low,
                     Integer *lhi, double d[]);
  extern void f01aty_f(Integer n, Integer ib, double a[], Integer ia,
                       Integer *low, Integer *lhi, double d[]);
  extern void f01atz_f(Integer m, double a[], Integer ia, double d[],
                       Integer k, Integer l, Integer n, Integer j);
  extern void f01atz(Integer m, double *a, Integer tda, double *d, 
                     Integer k, Integer l, Integer n, Integer j);
  extern void f01auc(Integer n, Integer low, Integer lhi, Integer m,  double d[],
                     double z[],  Integer tdz);
  //cheney change Complex to complex  2006-6-6
  /*extern void f01bcc(Integer n,  Complex a[], Integer tda,
                     double d[], double e[],
                     double c[], double s[]);
  extern void f01bcy( Integer m, Integer n, Complex a[], Integer tda,
                      Complex b[], Integer incb, double cr[], double ci[]);
  extern void f01bcz(Integer n, Complex a[], Integer tda, double br[],
                     double bi[], double cr[], double ci[]);
  extern NAG_DLL_EXPIMP void NAG_CALL f01bnc(Integer n, Complex a[], Integer tda, double p[], NagError *fail);*/
  extern void f01bcc(Integer n,  complex a[], Integer tda,
                     double d[], double e[],
                     double c[], double s[]);
  extern void f01bcy( Integer m, Integer n, complex a[], Integer tda,
                      complex b[], Integer incb, double cr[], double ci[]);
  extern void f01bcz(Integer n, complex a[], Integer tda, double br[],
                     double bi[], double cr[], double ci[]);
  extern NAG_DLL_EXPIMP void NAG_CALL f01bnc(Integer n, complex a[], Integer tda, double p[], NagError *fail);
  extern void f01bqc(Integer n, double *eps, double rl[],
                     double d[], Integer *row, NagError *fail);
  extern void f01bqz_f(Integer n, double *eps, double rl[], Integer irl,
                       double d[], Integer *ifail);
  extern void f01bqz(Integer n,  double *eps, double rl[],  Integer irl,
                     double d[],  Integer *ifail);
  extern void f01brg(double mat[], 
                     Integer col_num,
                     Integer lead_dim,
                     Integer trail_dim,
                     double vec[], 
                     Integer num_elements);
  extern void f01brh(double mat[], 
                     Integer col_num,
                     Integer lead_dim,
                     Integer trail_dim,
                     double vec[], 
                     Integer num_elements);
  //Cheney modify lmat [] to lmat[]
  /*extern void f01bri(double smat[], 
                     double lmat [],
                     Integer sr,
                     Integer sc,
                     Integer lr,
                     Integer lc);
  extern void f01brj(double smat[], 
                     double lmat [],
                     Integer sr,
                     Integer sc,
                     Integer lr,
                     Integer lc);*/
  extern void f01bri(double smat[], 
                     double lmat[],
                     Integer sr,
                     Integer sc,
                     Integer lr,
                     Integer lc);
  extern void f01brj(double smat[], 
                     double lmat[],
                     Integer sr,
                     Integer sc,
                     Integer lr,
                     Integer lc);
  extern void f01brk(Integer mat[], 
                     Integer col_num,
                     Integer lead_dim,
                     Integer trail_dim,
                     Integer vec[], 
                     Integer num_elements);
  extern void f01brl(Integer mat[], 
                     Integer col_num,
                     Integer lead_dim,
                     Integer trail_dim,
                     Integer vec[], 
                     Integer num_elements);
  extern NAG_DLL_EXPIMP void NAG_CALL f01crc(double *a, Integer m, Integer n, NagError *fail);
  extern void f01lef(Integer n,  double a[], double lambda, double b[],
                     double c[], double tol, double d[],  Integer in[],
                     Integer *ifail);
  extern void f01lzc(Integer n, double a[], Integer tda, double c[],
                     Integer tdc,  Boolean wantb, double b[], Boolean wantq,
                     Boolean wanty, double y[], Integer tdy, Integer ly,
                     Boolean wantz, double z[], Integer tdz, Integer ncz,
                     double d[], double e[], NagError *fail);
  extern void f01lzw(double t, double *c, double *s, double sqteps,
                     double rsqtps, double big);
  extern void f01lzx(Integer n, double c[], double s[], double x[]);
  extern void f01lzy(Integer n, double c, double s, double *x, double *y);
  extern double f01lzz(double a, double b, double small1, double big);
  extern NAG_DLL_EXPIMP void NAG_CALL f01mcc(Integer n, double *a, Integer lal, Integer *row, double *al, 
                                             double *d, NagError *fail);
  extern void f01qac(Integer m, Integer n, double a[], Integer tda, double c[],
                     Integer tdc, double z[], NagError *fail);
  extern void f01qaw_f(Integer n, double x[], double xmul, const double y[],
                       Boolean undflw);
  extern void f01qaw(Integer n, double *x, double xmul, double *y, Boolean undflw);
  extern double f01qax(Integer nr, Integer n, double v, Boolean plus,
                       double *x, double *y, Boolean undflw);
  extern void f01qay(Integer n, double *x, Boolean norm, double *z1, double small1,
                     double tiny, double big);
  extern void f01qaz(Integer n, double *z, double z1, double *x);
  extern void f01qbc(Integer m, Integer n,  double a[],  Integer tda,
                     double c[],  Integer tdc,  double work[],
                     NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f01qcc(Integer m, Integer n, double *a, Integer tda, double *zeta,
                                             NagError *fail);
  extern void f01qcf_f(Integer m, Integer n, double a[], Integer lda,
                       double zeta[], Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL f01qdc(MatrixTranspose trans, Nag_WhereElements wheret,
                                             Integer m, Integer n, double *a, Integer tda, double *zeta,
                                             Integer ncolb, double *b, Integer tdb, NagError *fail);
  extern void f01qdf_f(const char *trans, const char *wheret, Integer m, Integer n,
                       double a[], Integer lda, const double zeta[], Integer ncolb,
                       double b[], Integer ldb, double work[], Integer *ifail,
                       Integer trans_len, Integer wheret_len);
  extern NAG_DLL_EXPIMP void NAG_CALL f01qec(Nag_WhereElements wheret, Integer m, Integer n, Integer ncolq,
                                             double *a, Integer tda, double *zeta, NagError *fail);
  extern void f01qfc(const char *pivot,  Integer m, Integer n,  double a[],
                     Integer lda,  double zeta[],  Integer perm[],
                     double work[],  Integer *ifail);
  extern void f01qjc(Integer m, Integer n, double *a, Integer tda, double *zeta,
                     NagError *fail);
  extern void f01qkc(Nag_WhereElements wheret, Integer m, Integer n, Integer nrowp,
                     double *a, Integer tda, double *zeta, NagError *fail);
  //cheney change Complex to complex  2006-6-6
  /*extern NAG_DLL_EXPIMP void NAG_CALL f01rcc(Integer m, Integer n, Complex *a, Integer tda, Complex *theta,
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f01rdc(MatrixTranspose trans, Nag_WhereElements wheret, Integer m, Integer n,
                                             Complex *a, Integer tda, Complex *theta, Integer ncolb, 
                                             Complex *b, Integer tdb, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f01rec(Nag_WhereElements wheret, Integer m, Integer n, Integer ncolq, 
                                             Complex *a, Integer tda, Complex *theta, NagError *fail);
  extern void f01rjc(Integer m, Integer n, Complex *a, Integer tda, Complex *theta,
                     NagError *fail);
  extern void f01rkc(Nag_WhereElements wheret, Integer m, Integer n, Integer rowp,
                     Complex *a, Integer tda, Complex *theta, NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f01rcc(Integer m, Integer n, complex *a, Integer tda, complex *theta,
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f01rdc(MatrixTranspose trans, Nag_WhereElements wheret, Integer m, Integer n,
                                             complex *a, Integer tda, complex *theta, Integer ncolb, 
                                             complex *b, Integer tdb, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f01rec(Nag_WhereElements wheret, Integer m, Integer n, Integer ncolq, 
                                             complex *a, Integer tda, complex *theta, NagError *fail);
  extern void f01rjc(Integer m, Integer n, complex *a, Integer tda, complex *theta,
                     NagError *fail);
  extern void f01rkc(Nag_WhereElements wheret, Integer m, Integer n, Integer rowp,
                     complex *a, Integer tda, complex *theta, NagError *fail);
  extern void f01sag(Integer mode, Integer m, Integer n,  double v[],
                     double w[],  Integer lena, Integer luparm[],
                     double parmlu[], double a[],  Integer indc[],
                     Integer indr[], Integer ip[], Integer iq[], Integer lenc[],
                     Integer lenr[], Integer locc[], Integer locr[], 
                     Integer *inform);
  extern void f01sah(Integer m, Integer n,  double w[],  Integer lena,
                     Integer luparm[],  double parmlu[], double a[],
                     Integer indc[], Integer indr[], Integer ip[], 
                     Integer iq[], Integer lenc[], Integer lenr[], 
                     Integer locc[], Integer locr[], Integer *inform);
  extern void f01saj(Integer n,  Boolean reals,  Integer luparm[], Integer *ltop,
                     Integer lena,  double a[],  Integer ind[], Integer len[],
                     Integer loc[]);
  extern void f01sak(Integer n, Integer len[], Integer iperm[], Integer iw[],
                     Integer *nrank);
  extern void f01sal(Integer nzpiv, Integer *nzchng, Integer indr[], 
                     Integer lenold[], Integer lennew[], Integer iqloc[], 
                     Integer iq[], Integer iqinv[]);
  extern void f01sam(Integer m, Integer n, Integer len[], Integer iperm[],
                     Integer loc[], Integer inv[], Integer num[]);
  extern void f01san(Integer m, Integer melim, Integer ncold, Integer nspare,
                     Integer lpivc1, Integer lpivc2, Integer lpivr1, Integer lpivr2,
                     Integer *lrow, Integer lenc[], Integer lenr[], Integer locc[],
                     Integer locr[], Integer indc[], Integer indr[], 
                     Integer ifill[], Integer jfill[]);
  extern void f01sap(Integer m, Integer n, Integer nelem, Integer indc[],
                     Integer indr[], Integer lenc[], Integer lenr[], 
                     Integer locc[], Integer locr[]);
  extern void f01saq(Integer m, Integer n, Integer nelem, const Integer indc[],
                     Integer lenc[], Integer locc[], Integer iw[], Integer *lerr,
                     Integer *inform);
  extern void f01sar(Integer n, Integer numa,  double a[],  Integer inum[],
                     Integer jnum[], Integer len[], Integer loc[]);
  extern void f01sas(Integer m, Integer n, Integer nelem,  double small1,
                     double a[],  Integer indc[], Integer indr[], Integer lenc[],
                     Integer lenr[],  double *amax,  Integer *numnz,
                     Integer *lerr, Integer *inform);
  extern void f01sat(Integer kol1, Integer kol2, Integer kol[],  double a[],
                     Integer indc[], Integer lenc[], Integer locc[]);
  extern void f01sau(Integer m, Integer n, Integer lena, Integer maxmn,
                     double lmax,  Integer maxcol, Integer maxrow, Integer *ibest,
                     Integer *jbest, Integer *mbest,  double a[],  Integer indc[],
                     Integer indr[], Integer ip[], Integer iq[], Integer lenc[],
                     Integer lenr[], Integer locc[], Integer locr[], Integer iploc[],
                     Integer iqloc[]);
  extern void f01sav(Integer m, Integer melim, Integer ncold, Integer nspare,
                     double small1,  Integer lpivc1, Integer lpivc2,
                     Integer *lfirst, Integer lpivr2, Integer lfree, Integer minfre,
                     Integer *lrow, Integer *lcol, Integer *lu, Integer *nfill,
                     double a[],  Integer indc[], Integer indr[], Integer lenc[],
                     Integer lenr[], Integer locc[], Integer locr[], Integer mark[],
                     double al[],  Integer markl[],  double au[],
                     Integer ifill[], Integer jfill[]);
  extern void f01saw(Integer m, Integer n, Integer lena, Integer lend, Integer lu1,
                     Integer mleft, Integer nleft, Integer nrank, Integer nrowu,
                     Integer *lenl, Integer *lenu, Integer *nsing,  Boolean keeplu,
                     double small1, double a[], double d[],
                     Integer indc[], Integer indr[], Integer ip[], Integer iq[],
                     Integer lenc[], Integer lenr[], Integer locc[], Integer ipinv[],
                     Integer ipvt[]);
  extern void f01sax(Integer m, Integer n, Integer nelem, Integer lena,
                     Integer luparm[],  double parmlu[], double a[],
                     Integer indc[], Integer indr[], Integer ip[], Integer iq[],
                     Integer lenc[], Integer lenr[], Integer locc[], Integer locr[],
                     Integer iploc[], Integer iqloc[], Integer ipinv[], Integer iqinv[],
                     Integer *inform, Integer *lenl, Integer *lenu, Integer *minlen,
                     Integer *mersum, Integer *nutri, Integer *nltri, Integer *nrank);
  extern void f01say(Integer m, Integer n, Integer *nelem, Integer lena,
                     Integer luparm[],  double parmlu[], double a[],
                     Integer indc[], Integer indr[], Integer ip[], Integer iq[],
                     Integer lenc[], Integer lenr[], Integer locc[], Integer locr[],
                     Integer iploc[], Integer iqloc[], Integer ipinv[],
                     Integer iqinv[],  double w[],  Integer *inform);
  extern void f01saz(double a[],  Integer lda, Integer m, Integer n,
                     double small1,  Integer *nsing, Integer ipvt[], Integer iq[]);
  extern void f01sbt(Integer mode1, Integer mode2, Integer m, Integer n,
                     Integer jrep,  double v[], double w[],  Integer lena,
                     Integer luparm[],  double parmlu[], double a[],
                     Integer indc[], Integer indr[], Integer ip[], Integer iq[],
                     Integer lenc[], Integer lenr[], Integer locc[], Integer locr[],
                     Integer *inform,  double *diag, double *vnorm);
  extern void f01sbu(Integer m, Integer n, Integer jzap, Integer *kzap, 
                     Integer lena, Integer *lenu, Integer *lrow, Integer nrank,  
                     double a[], Integer indr[], Integer ip[], Integer iq[], 
                     Integer lenr[], Integer locr[]);
  extern void f01sbv(Integer m, Integer n, Integer jsing, Integer lena,
                     Integer luparm[],  double parmlu[],  Integer *lenu,
                     Integer *lrow, Integer *nrank,  double a[],  Integer indc[],
                     Integer indr[], Integer ip[], Integer iq[], Integer lenr[],
                     Integer locc[], Integer locr[], Integer *inform,
                     double *diag);
  extern void f01sbw(Integer m, Integer n, Integer kfirst, Integer klast,
                     Integer lena, Integer luparm[],  double parmlu[],
                     Integer *lenl, Integer *lenu, Integer *lrow,  double a[],
                     Integer indc[], Integer indr[], Integer ip[], Integer iq[],
                     Integer lenr[], Integer locc[], Integer locr[], 
                     Integer *inform, double *diag);
  extern void f01sbx(Integer m, Integer n, Integer jelm,  double v[],
                     Integer lena, Integer luparm[],  double parmlu[],
                     Integer *lenl, Integer *lrow, Integer nrank,  double a[],
                     Integer indc[], Integer indr[], Integer ip[], Integer iq[],
                     Integer lenr[], Integer locc[], Integer locr[], 
                     Integer *inform, double *diag);
  extern void f01sby(Integer kfirst, Integer klast, Integer ip[]);
  extern void f01sbz(Integer m, Integer jadd,  double v[],  Integer lena,
                     Integer luparm[],  double parmlu[],  Integer lenl,
                     Integer *lenu, Integer *lrow, Integer nrank,  double a[],
                     Integer indr[], Integer ip[], Integer lenr[], Integer locr[],
                     Integer *inform, Integer *klast,  double *vnorm);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF01 */
